<?php
// api/lang_tts_google.php
declare(strict_types=1);
require_once __DIR__.'/config.php';
require_once dirname(__DIR__).'/vendor/autoload.php';
use Google\Cloud\TextToSpeech\V1\TextToSpeechClient;

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

try {
  $gcp = getenv('GOOGLE_APPLICATION_CREDENTIALS') ?: (defined('GCP_CREDENTIALS') ? GCP_CREDENTIALS : null);
  $tts = new TextToSpeechClient(['transport'=>'rest','credentials'=>$gcp]);
  $resp = $tts->listVoices();
  $voices = [];
  $langsSet = [];
  foreach ($resp->getVoices() as $v) {
    $langs = $v->getLanguageCodes();
    foreach ($langs as $lc) $langsSet[$lc] = true;
    $voices[] = [
      'name' => $v->getName(),
      'language_codes' => iterator_to_array($v->getLanguageCodes()),
      'ssml_gender' => $v->getSsmlGender(),
      'natural_sample_rate_hertz' => $v->getNaturalSampleRateHertz()
    ];
  }
  echo json_encode([
    'ok'=>true,
    'provider'=>'google-tts',
    'languages'=>array_keys($langsSet), // toutes les langues supportées par au moins une voix
    'voices'=>$voices
  ], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>$e->getMessage()]);
}
