<?php
declare(strict_types=1);
header('Content-Type: text/plain; charset=utf-8');

$autoload = dirname(__DIR__) . '/vendor/autoload.php';
echo 'cwd=' . __DIR__ . "\n";
echo 'autoload.path=' . $autoload . "\n";
if (!file_exists($autoload)) { echo "autoload.loaded=NO\n"; exit(1); }
require_once $autoload;
echo "autoload.loaded=YES\n";

$configPath = __DIR__ . '/config.php';
echo 'config.path=' . $configPath . "\n";
if (file_exists($configPath)) require_once $configPath;

echo 'php.version=' . PHP_VERSION . "\n";
echo 'php.sapi=' . PHP_SAPI . "\n";
echo 'env.GOOGLE_APPLICATION_CREDENTIALS=' . (getenv('GOOGLE_APPLICATION_CREDENTIALS') ?: 'NOT SET') . "\n";

function probe(string $label, string $fqcn): void {
  echo $label . '[' . $fqcn . ']=' . (class_exists($fqcn) ? 'YES' : 'NO') . "\n";
}

probe('speech.v2.class', '\Google\Cloud\Speech\V2\Client\SpeechClient');
probe('tts.class', '\Google\Cloud\TextToSpeech\V1\TextToSpeechClient');

$baseSpeech = dirname(__DIR__) . '/vendor/google/cloud-speech/src';
echo 'speech.src.dir.exists=' . (is_dir($baseSpeech) ? 'YES' : 'NO') . "\n";
echo 'php.open_basedir=' . (ini_get('open_basedir') ?: 'EMPTY') . "\n";
echo 'php.include_path=' . (ini_get('include_path') ?: 'EMPTY') . "\n";

try {
  if (class_exists('\Google\Cloud\TextToSpeech\V1\TextToSpeechClient')) {
    $tts = new \Google\Cloud\TextToSpeech\V1\TextToSpeechClient();
    echo "tts.client.new=OK\n";
    if (method_exists($tts,'close')) $tts->close();
  }
} catch (Throwable $e) { echo 'tts.client.new=ERR ' . $e->getMessage() . "\n"; }

try {
  if (class_exists('\Google\Cloud\Speech\V2\Client\SpeechClient')) {
    $speech = new \Google\Cloud\Speech\V2\Client\SpeechClient();
    echo "speech.client.v2.new=OK\n";
  } else {
    echo "speech.client.v2.new=MISS\n";
  }
} catch (Throwable $e) { echo 'speech.client.v2.new=ERR ' . $e->getMessage() . "\n"; }

if (function_exists('opcache_reset')) { opcache_reset(); echo "opcache.reset=DONE\n"; }
