<?php
// api/lang_whitelist.php
declare(strict_types=1);

ini_set('display_errors', '1');
error_reporting(E_ALL);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: GET, OPTIONS');

require_once __DIR__ . '/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

$stt = [];
$target = [];
foreach (LANG_WHITELIST as $code => $meta) {
  if (!empty($meta['stt']))    $stt[]    = ['code'=>$code, 'name'=>$meta['name']];
  if (!empty($meta['target'])) $target[] = ['code'=>$code, 'name'=>$meta['name']];
}

echo json_encode([
  'ok' => true,
  'stt' => $stt,
  'target' => $target,
], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
