<?php
// api/lang_stt_list.php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: GET, OPTIONS');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

/**
 * Liste BCP-47 couvrant les langues couramment supportées par Google Speech v2.
 * Tu peux en ajouter/retirer librement – le front charge dynamiquement.
 * (Codes majeurs + variantes régionales usuelles)
 */
$LANGS = [
  ['code'=>'af-ZA','name'=>'Afrikaans (Afrique du Sud)'],
  ['code'=>'am-ET','name'=>'Amharique (Éthiopie)'],
  ['code'=>'ar-AE','name'=>'Arabe (Émirats)'],['code'=>'ar-BH','name'=>'Arabe (Bahreïn)'],['code'=>'ar-DZ','name'=>'Arabe (Algérie)'],
  ['code'=>'ar-EG','name'=>'Arabe (Égypte)'],['code'=>'ar-IQ','name'=>'Arabe (Irak)'],['code'=>'ar-JO','name'=>'Arabe (Jordanie)'],
  ['code'=>'ar-KW','name'=>'Arabe (Koweït)'],['code'=>'ar-LB','name'=>'Arabe (Liban)'],['code'=>'ar-MA','name'=>'Arabe (Maroc)'],
  ['code'=>'ar-OM','name'=>'Arabe (Oman)'],['code'=>'ar-QA','name'=>'Arabe (Qatar)'],['code'=>'ar-SA','name'=>'Arabe (Arabie Saoudite)'],
  ['code'=>'ar-TN','name'=>'Arabe (Tunisie)'],['code'=>'ar-YE','name'=>'Arabe (Yémen)'],
  ['code'=>'az-AZ','name'=>'Azéri (Azerbaïdjan)'],
  ['code'=>'be-BY','name'=>'Biélorusse'],
  ['code'=>'bg-BG','name'=>'Bulgare'],
  ['code'=>'bn-BD','name'=>'Bengali (Bangladesh)'],['code'=>'bn-IN','name'=>'Bengali (Inde)'],
  ['code'=>'bs-BA','name'=>'Bosnien'],
  ['code'=>'ca-ES','name'=>'Catalan'],
  ['code'=>'cs-CZ','name'=>'Tchèque'],
  ['code'=>'cy-GB','name'=>'Gallois'],
  ['code'=>'da-DK','name'=>'Danois'],
  ['code'=>'de-DE','name'=>'Allemand (Allemagne)'],['code'=>'de-AT','name'=>'Allemand (Autriche)'],['code'=>'de-CH','name'=>'Allemand (Suisse)'],
  ['code'=>'el-GR','name'=>'Grec'],
  ['code'=>'en-AU','name'=>'Anglais (Australie)'],['code'=>'en-CA','name'=>'Anglais (Canada)'],['code'=>'en-GB','name'=>'Anglais (Royaume-Uni)'],
  ['code'=>'en-GH','name'=>'Anglais (Ghana)'],['code'=>'en-HK','name'=>'Anglais (Hong Kong)'],['code'=>'en-IE','name'=>'Anglais (Irlande)'],
  ['code'=>'en-IN','name'=>'Anglais (Inde)'],['code'=>'en-KE','name'=>'Anglais (Kenya)'],['code'=>'en-NG','name'=>'Anglais (Nigeria)'],
  ['code'=>'en-NZ','name'=>'Anglais (Nouvelle-Zélande)'],['code'=>'en-PH','name'=>'Anglais (Philippines)'],
  ['code'=>'en-SG','name'=>'Anglais (Singapour)'],['code'=>'en-TZ','name'=>'Anglais (Tanzanie)'],['code'=>'en-US','name'=>'Anglais (États-Unis)'],
  ['code'=>'en-ZA','name'=>'Anglais (Afrique du Sud)'],
  ['code'=>'es-AR','name'=>'Espagnol (Argentine)'],['code'=>'es-BO','name'=>'Espagnol (Bolivie)'],['code'=>'es-CL','name'=>'Espagnol (Chili)'],
  ['code'=>'es-CO','name'=>'Espagnol (Colombie)'],['code'=>'es-CR','name'=>'Espagnol (Costa Rica)'],['code'=>'es-DO','name'=>'Espagnol (Rép. Dominicaine)'],
  ['code'=>'es-EC','name'=>'Espagnol (Équateur)'],['code'=>'es-ES','name'=>'Espagnol (Espagne)'],['code'=>'es-GT','name'=>'Espagnol (Guatemala)'],
  ['code'=>'es-HN','name'=>'Espagnol (Honduras)'],['code'=>'es-MX','name'=>'Espagnol (Mexique)'],['code'=>'es-NI','name'=>'Espagnol (Nicaragua)'],
  ['code'=>'es-PA','name'=>'Espagnol (Panama)'],['code'=>'es-PE','name'=>'Espagnol (Pérou)'],['code'=>'es-PR','name'=>'Espagnol (Porto Rico)'],
  ['code'=>'es-PY','name'=>'Espagnol (Paraguay)'],['code'=>'es-SV','name'=>'Espagnol (Salvador)'],['code'=>'es-UY','name'=>'Espagnol (Uruguay)'],
  ['code'=>'es-VE','name'=>'Espagnol (Venezuela)'],
  ['code'=>'et-EE','name'=>'Estonien'],['code'=>'eu-ES','name'=>'Basque'],
  ['code'=>'fa-IR','name'=>'Persan (Farsi)'],
  ['code'=>'fi-FI','name'=>'Finnois'],
  ['code'=>'fil-PH','name'=>'Filipino (Tagalog)'],
  ['code'=>'fr-BE','name'=>'Français (Belgique)'],['code'=>'fr-CA','name'=>'Français (Canada)'],['code'=>'fr-CH','name'=>'Français (Suisse)'],['code'=>'fr-FR','name'=>'Français (France)'],
  ['code'=>'gl-ES','name'=>'Galicien'],
  ['code'=>'gu-IN','name'=>'Gujarati'],
  ['code'=>'he-IL','name'=>'Hébreu'],
  ['code'=>'hi-IN','name'=>'Hindi'],
  ['code'=>'hr-HR','name'=>'Croate'],
  ['code'=>'hu-HU','name'=>'Hongrois'],
  ['code'=>'hy-AM','name'=>'Arménien'],
  ['code'=>'id-ID','name'=>'Indonésien'],
  ['code'=>'is-IS','name'=>'Islandais'],
  ['code'=>'it-IT','name'=>'Italien'],
  ['code'=>'ja-JP','name'=>'Japonais'],
  ['code'=>'jv-ID','name'=>'Javanais'],
  ['code'=>'ka-GE','name'=>'Géorgien'],
  ['code'=>'kk-KZ','name'=>'Kazakh'],
  ['code'=>'km-KH','name'=>'Khmer'],
  ['code'=>'kn-IN','name'=>'Kannada'],
  ['code'=>'ko-KR','name'=>'Coréen'],
  ['code'=>'ky-KG','name'=>'Kirghiz'],
  ['code'=>'lo-LA','name'=>'Lao'],
  ['code'=>'lt-LT','name'=>'Lituanien'],
  ['code'=>'lv-LV','name'=>'Letton'],
  ['code'=>'mk-MK','name'=>'Macédonien'],
  ['code'=>'ml-IN','name'=>'Malayalam'],
  ['code'=>'mn-MN','name'=>'Mongol'],
  ['code'=>'mr-IN','name'=>'Marathi'],
  ['code'=>'ms-MY','name'=>'Malais'],
  ['code'=>'mt-MT','name'=>'Maltais'],
  ['code'=>'my-MM','name'=>'Birman (Myanmar)'],
  ['code'=>'nb-NO','name'=>'Norvégien (Bokmål)'],
  ['code'=>'ne-NP','name'=>'Népalais'],
  ['code'=>'nl-BE','name'=>'Néerlandais (Belgique)'],['code'=>'nl-NL','name'=>'Néerlandais (Pays-Bas)'],
  ['code'=>'pa-IN','name'=>'Panjabi (Gurmukhi)'],
  ['code'=>'pl-PL','name'=>'Polonais'],
  ['code'=>'ps-AF','name'=>'Pachto'],
  ['code'=>'pt-BR','name'=>'Portugais (Brésil)'],['code'=>'pt-PT','name'=>'Portugais (Portugal)'],
  ['code'=>'ro-RO','name'=>'Roumain'],
  ['code'=>'ru-RU','name'=>'Russe'],
  ['code'=>'si-LK','name'=>'Singhalais'],
  ['code'=>'sk-SK','name'=>'Slovaque'],
  ['code'=>'sl-SI','name'=>'Slovène'],
  ['code'=>'sq-AL','name'=>'Albanais'],
  ['code'=>'sr-RS','name'=>'Serbe'],
  ['code'=>'su-ID','name'=>'Soundanais'],
  ['code'=>'sv-SE','name'=>'Suédois'],
  ['code'=>'sw-KE','name'=>'Swahili (Kenya)'],['code'=>'sw-TZ','name'=>'Swahili (Tanzanie)'],
  ['code'=>'ta-IN','name'=>'Tamoul (Inde)'],['code'=>'ta-LK','name'=>'Tamoul (Sri Lanka)'],
  ['code'=>'te-IN','name'=>'Télougou'],
  ['code'=>'th-TH','name'=>'Thaï'],
  ['code'=>'tr-TR','name'=>'Turc'],
  ['code'=>'uk-UA','name'=>'Ukrainien'],
  ['code'=>'ur-IN','name'=>'Ourdou (Inde)'],['code'=>'ur-PK','name'=>'Ourdou (Pakistan)'],
  ['code'=>'uz-UZ','name'=>'Ouzbek'],
  ['code'=>'vi-VN','name'=>'Vietnamien'],
  ['code'=>'zh-CN','name'=>'Chinois (Simplifié, Chine)'],
  ['code'=>'zh-HK','name'=>'Chinois (Hong Kong)'],
  ['code'=>'zh-TW','name'=>'Chinois (Traditionnel, Taïwan)'],
  ['code'=>'zu-ZA','name'=>'Zoulou'],
];

echo json_encode(['ok'=>true, 'languages'=>$LANGS], JSON_UNESCAPED_UNICODE);
