<?php
// api/lang_translate.php
declare(strict_types=1);

require_once __DIR__.'/config.php';
require_once dirname(__DIR__).'/vendor/autoload.php';
use Google\Cloud\Translate\V2\TranslateClient;

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: GET, OPTIONS');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

/**
 * Fallback statique (codes ISO 639-1) au cas où l'appel Google échoue.
 * Nom affiché en français pour l'UI.
 * Liste large couvrant >100 langues communes de Google Translate.
 */
$fallback = [
  ['code'=>'af','name'=>'Afrikaans'],['code'=>'sq','name'=>'Albanais'],['code'=>'am','name'=>'Amharique'],
  ['code'=>'ar','name'=>'Arabe'],['code'=>'hy','name'=>'Arménien'],['code'=>'az','name'=>'Azéri'],
  ['code'=>'eu','name'=>'Basque'],['code'=>'be','name'=>'Biélorusse'],['code'=>'bn','name'=>'Bengali'],
  ['code'=>'bs','name'=>'Bosnien'],['code'=>'bg','name'=>'Bulgare'],['code'=>'my','name'=>'Birman'],
  ['code'=>'ca','name'=>'Catalan'],['code'=>'ceb','name'=>'Cebuano'],['code'=>'ny','name'=>'Chichewa'],
  ['code'=>'zh','name'=>'Chinois'],['code'=>'zh-CN','name'=>'Chinois (simplifié)'],['code'=>'zh-TW','name'=>'Chinois (traditionnel)'],
  ['code'=>'co','name'=>'Corse'],['code'=>'hr','name'=>'Croate'],['code'=>'cs','name'=>'Tchèque'],
  ['code'=>'da','name'=>'Danois'],['code'=>'nl','name'=>'Néerlandais'],['code'=>'en','name'=>'Anglais'],
  ['code'=>'eo','name'=>'Espéranto'],['code'=>'et','name'=>'Estonien'],['code'=>'fil','name'=>'Filipino'],
  ['code'=>'fi','name'=>'Finnois'],['code'=>'fr','name'=>'Français'],['code'=>'fy','name'=>'Frison'],
  ['code'=>'gl','name'=>'Galicien'],['code'=>'ka','name'=>'Géorgien'],['code'=>'de','name'=>'Allemand'],
  ['code'=>'el','name'=>'Grec'],['code'=>'gu','name'=>'Gujarati'],['code'=>'ht','name'=>'Créole haïtien'],
  ['code'=>'ha','name'=>'Haoussa'],['code'=>'haw','name'=>'Hawaïen'],['code'=>'he','name'=>'Hébreu'],
  ['code'=>'hi','name'=>'Hindi'],['code'=>'hmn','name'=>'Hmong'],['code'=>'hu','name'=>'Hongrois'],
  ['code'=>'is','name'=>'Islandais'],['code'=>'ig','name'=>'Igbo'],['code'=>'id','name'=>'Indonésien'],
  ['code'=>'ga','name'=>'Irlandais'],['code'=>'it','name'=>'Italien'],['code'=>'ja','name'=>'Japonais'],
  ['code'=>'jv','name'=>'Javanais'],['code'=>'kn','name'=>'Kannada'],['code'=>'kk','name'=>'Kazakh'],
  ['code'=>'km','name'=>'Khmer'],['code'=>'rw','name'=>'Kinyarwanda'],['code'=>'ko','name'=>'Coréen'],
  ['code'=>'ku','name'=>'Kurde'],['code'=>'ky','name'=>'Kirghiz'],['code'=>'lo','name'=>'Lao'],
  ['code'=>'la','name'=>'Latin'],['code'=>'lv','name'=>'Letton'],['code'=>'lt','name'=>'Lituanien'],
  ['code'=>'lb','name'=>'Luxembourgeois'],['code'=>'mk','name'=>'Macédonien'],['code'=>'mg','name'=>'Malgache'],
  ['code'=>'ms','name'=>'Malais'],['code'=>'ml','name'=>'Malayalam'],['code'=>'mt','name'=>'Maltais'],
  ['code'=>'mi','name'=>'Maori'],['code'=>'mr','name'=>'Marathi'],['code'=>'mn','name'=>'Mongol'],
  ['code'=>'ne','name'=>'Népalais'],['code'=>'no','name'=>'Norvégien'],['code'=>'or','name'=>'Odia (Oriya)'],
  ['code'=>'ps','name'=>'Pachto'],['code'=>'fa','name'=>'Persan'],['code'=>'pl','name'=>'Polonais'],
  ['code'=>'pt','name'=>'Portugais'],['code'=>'pa','name'=>'Panjabi'],['code'=>'ro','name'=>'Roumain'],
  ['code'=>'ru','name'=>'Russe'],['code'=>'sm','name'=>'Samoan'],['code'=>'gd','name'=>'Gaélique écossais'],
  ['code'=>'sr','name'=>'Serbe'],['code'=>'sn','name'=>'Shona'],['code'=>'sd','name'=>'Sindhi'],
  ['code'=>'si','name'=>'Singhalais'],['code'=>'sk','name'=>'Slovaque'],['code'=>'sl','name'=>'Slovène'],
  ['code'=>'so','name'=>'Somali'],['code'=>'st','name'=>'Sotho du Sud'],['code'=>'es','name'=>'Espagnol'],
  ['code'=>'su','name'=>'Soundanais'],['code'=>'sw','name'=>'Swahili'],['code'=>'sv','name'=>'Suédois'],
  ['code'=>'tl','name'=>'Tagalog'],['code'=>'tg','name'=>'Tadjik'],['code'=>'ta','name'=>'Tamoul'],
  ['code'=>'tt','name'=>'Tatar'],['code'=>'te','name'=>'Télougou'],['code'=>'th','name'=>'Thaï'],
  ['code'=>'tr','name'=>'Turc'],['code'=>'tk','name'=>'Turkmène'],['code'=>'uk','name'=>'Ukrainien'],
  ['code'=>'ur','name'=>'Ourdou'],['code'=>'ug','name'=>'Ouïghour'],['code'=>'uz','name'=>'Ouzbek'],
  ['code'=>'vi','name'=>'Vietnamien'],['code'=>'cy','name'=>'Gallois'],['code'=>'xh','name'=>'Xhosa'],
  ['code'=>'yi','name'=>'Yiddish'],['code'=>'yo','name'=>'Yoruba'],['code'=>'zu','name'=>'Zoulou'],
];

try {
  $gcp = getenv('GOOGLE_APPLICATION_CREDENTIALS') ?: (defined('GCP_CREDENTIALS') ? GCP_CREDENTIALS : null);
  if (!$gcp || !is_readable($gcp)) {
    echo json_encode(['ok'=>true, 'languages'=>$fallback, 'note'=>'fallback']); exit;
  }
  $tr  = new TranslateClient(['keyFilePath' => $gcp]);
  // Noms localisés (UI en français). Mets 'en' si tu préfères.
  $langs = $tr->languages(['target' => 'fr']);
  $out = [];
  foreach ($langs as $it) {
    // la lib peut renvoyer 'code' ou 'language'
    $code = $it['code'] ?? ($it['language'] ?? null);
    $name = $it['name'] ?? null;
    if ($code) $out[] = ['code'=>$code, 'name'=>$name ?: strtoupper($code)];
  }
  // Si Google renvoie vide, on retombe sur fallback
  if (!$out) $out = $fallback;
  echo json_encode(['ok'=>true, 'languages'=>$out], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  // En cas d'erreur API, on sert le fallback pour ne pas bloquer l’UI
  echo json_encode(['ok'=>true, 'languages'=>$fallback, 'note'=>'fallback', 'warn'=>$e->getMessage()], JSON_UNESCAPED_UNICODE);
}
