<?php
// api/config.php
declare(strict_types=1);

// --- Debug (désactive en prod) ---
ini_set('display_errors', '1');
error_reporting(E_ALL);

// --- Dossiers projet ---
define('SESSIONS_DIR', __DIR__ . '/sessions');
define('TTS_PUBLIC_DIR', dirname(__DIR__) . '/public/tts');

@mkdir(SESSIONS_DIR, 0775, true);
@mkdir(TTS_PUBLIC_DIR, 0775, true);

// --- CORS minimal (restreins à ton domaine en prod) ---
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');

// --- Limites utiles ---
@ini_set('upload_max_filesize', '50M');
@ini_set('post_max_size', '50M');
@ini_set('max_execution_time', '120');

// --- Google credentials ---
// Mets ici le chemin EXACT vers ta clé JSON de Service Account :
$GCP_CREDENTIALS = '/home/miva/FileDocs/miva-connect-473519-75b4e78ab97f.json';
putenv('GOOGLE_APPLICATION_CREDENTIALS=' . $GCP_CREDENTIALS);
define('GCP_CREDENTIALS', $GCP_CREDENTIALS);
